<?php
/* --------------------------------------------------------------
   OrderId.php 2020-01-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Models;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalOrderId;
use InvalidArgumentException;
use Webmozart\Assert\Assert;

/**
 * Class OrderId
 *
 * @package Gambio\Admin\Withdrawal\Models
 */
class OrderId implements WithdrawalOrderId
{
    /**
     * @var int|null
     */
    private $value;
    
    
    /**
     * OrderId constructor.
     *
     * @param int|null $value
     */
    private function __construct(?int $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * Creates a new OrderId instance.
     *
     * @param int|null $value
     *
     * @return OrderId
     *
     * @throws InvalidArgumentException
     */
    public static function create(?int $value = null): OrderId
    {
        if ($value !== null) {
            Assert::greaterThan($value, 0, 'The order ID must be a positive integer. Got: %s');
        }
        
        return new self($value);
    }
    
    
    /**
     * Returns the value of this ID.
     *
     * @return int|null
     */
    public function value(): ?int
    {
        return $this->value;
    }
}